'use strict';

/* Controllers */
function BCPChattelCtrl($scope, $rootScope, $route, STList, STCurrentList, Company, BanksList)
{
    Company.init();
    $scope.company =  Company;

    //Lista ofert kupna środków trwałych
    $scope.offersList = $route.current.locals.offersList;
    //Lista posiadanych środków trwałych i nieruchomości
    $scope.chattel =  Company.STCurrentList;

    $scope.types = STList.types;

    $scope.methodType = 'bcp-chattel';


    $scope.showItemProperties = false;


    $scope._filter = function(type){
        return function(record) {
            return record.type.symbol == type;
        };
    }


    $scope.openOffers = function(type){
        $rootScope.$broadcast('Chattel:openWindow', type);
    }

    $scope.showToken = function() {
        var params = {};
        params.title = 'Wyposażenie';
        params.tokensConfirmsMessage = 'controlPanel,'+'chattel';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = [];
        $scope.chattel.forEach(function(item){
            if(item.isChanged() && !item.isPlace())
            {
                var value = item._totalQuantity - item._originalQuantity;
                if(value > 0)
                {
                    params.changes.push(item.name + ' - zakupiono ' + value + ' szt.');
                }
                else
                {
                    params.changes.push(item.name + ' - sprzedano ' + (-1 * value) + ' szt.');
                }
            }
        });
        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal', $scope.company, params, $scope.methodType);
//        $rootScope.$broadcast('Tokens:closeSubmitTokensModal', $scope.methodType);
    }


    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType){

            $scope.chattel.forEach(function(item){
                if(item.isChanged() && !item.isPlace())
                {
                    item.save();
                }
            });


            BanksList.setReloadData();
        }
    });

    $scope.isAnyChanged = function(){
        return STCurrentList.isAnyChanged()
    }


    $scope.showProperties = function(Item){
        $scope.showItemProperties = ($scope.showItemProperties == Item) ? false : Item;
    }

    $scope.removeItemPosition = function(item, pos){
        var CurrentAccount = BanksList.getCurrentAccount();
        if((typeof pos.loan_type != 'undefined' && pos.loan_type == false) || (typeof pos.loan_id != 'undefined' && pos.loan_id == null))
        {
            CurrentAccount.company_bank_service_options[0].value += pos.quantity * pos.price;
        }
        item._totalQuantity -= pos.quantity;
        pos.quantity = 0;
    }


    /**
     * Sprawdza czy dana pozycje zakupu można usunąć
     * @param cbso
     * @returns {boolean}
     */
    $scope.isAbleToRemove = function(cbso){
        return cbso.round_id == roundId;
    }


    /**
     * Czy dana pozycja środka trwałego została sfinasowana z kredytu
     * @param cbso
     * @returns {boolean}
     */
    $scope.isLoanBuy = function(cbso){
        return ((typeof cbso.loan_id != 'undefined' && cbso.loan_id != null && cbso.loan_id > 0) || (typeof cbso.loan_type != 'undefined' && cbso.loan_type != false));
    }
}

BCPChattelCtrl.$inject = ['$scope', '$rootScope', '$route', 'STList', 'STCurrentList', 'Company', 'BanksList'];

BCPChattelCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}


BCPChattelCtrl.getRandomOffers = function($q, $route, $rootScope, FrontCreatorChattel, STList){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorChattel.getRandomOffers(function(data){
        $rootScope.decLoading();
        STList.setData(data);
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}